
    // base attack
    public  interface IAttack
    {
        public  string Name { get; }
        AttackData GenerateAttackData();
    }

    public class Punch : IAttack
    {
        public string Name => "PUNCH";

        public AttackData GenerateAttackData()
        {
            return new AttackData(1
            );
        }
    
    }

    public class BoneCrunch : IAttack
    {
        public string Name => "BONE CRUNCH";
        private static readonly Random _random = new Random();

        public AttackData GenerateAttackData()
        {
            int damage = _random.Next(2);
            return new AttackData(damage);
            
        }
    }

    public class ForgetfulSpell : IAttack
    {
        public string Name => "FORGETFUL SPELL";
        private static readonly Random random = new Random();
        public AttackData GenerateAttackData()
        {
            int damage = random.Next(3);

            return new AttackData(damage);
        }
    }
    // Attack stats
    public class AttackData
    {
        public int Damage { get; }

        public AttackData(int damage)
        {
            Damage = damage;
        }
    }